/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.config;

import com.ibm.hwmca.fw.pa.config.AnalysisDomainData;
import com.ibm.hwmca.fw.pa.config.AnalysisEventData;
import com.ibm.hwmca.fw.pa.config.AnalysisEventsData;
import com.ibm.hwmca.fw.pa.config.AnalysisRoutineData;
import com.ibm.hwmca.fw.pa.config.AnalysisRoutinesData;
import com.ibm.hwmca.fw.pa.config.ConfigurationData;
import com.ibm.hwmca.fw.pa.config.ConsoleADData;
import com.ibm.hwmca.fw.pa.config.DistributedADData;
import com.ibm.hwmca.fw.pa.config.EventGeneratorData;
import com.ibm.hwmca.fw.pa.config.EventGeneratorsData;
import com.ibm.hwmca.fw.pa.config.EventManagerData;
import com.ibm.hwmca.fw.pa.config.PersistenceData;
import com.ibm.hwmca.fw.pa.config.ProblemAnalysisData;
import com.ibm.hwmca.fw.pa.config.ProblemManagerData;
import com.ibm.hwmca.fw.pa.config.RemoteSystemManagerData;
import com.ibm.hwmca.fw.pa.config.RemoteSystemProviderData;
import com.ibm.hwmca.fw.pa.config.RemoteSystemProvidersData;
import com.ibm.hwmca.fw.service.config.ClassData;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.xml.ConfigData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class ProblemAnalysisXMLParser
extends CommonXMLParser
implements ErrorHandler {
    private static final String TRACE_MASKT = "XPAPXMLT";
    private static final String TRACE_MASKF = "XPAPXMLF";
    private static final String TRACE_MASKD = "XPAPXMLD";
    private static final String TAG_ANALYSIS_DOMAINS = "analysis-domains";
    private static final String TAG_ANALYSIS_EVENTS = "analysis-events";
    private static final String TAG_ANALYSIS_ROUTINES = "analysis-routines";
    private static final String TAG_SPECIAL_REFCODES = "special-refcodes";
    private static final String TAG_REFCODE = "refcode";
    private static final String TAG_CLASS = "class";
    private static final String TAG_CONFIG_DATA = "config-data";
    private static final String TAG_EVENT = "event";
    private static final String TAG_EVENT_GENERATORS = "event-generators";
    private static final String TAG_EVENT_MANAGER = "event-manager";
    private static final String TAG_KEY = "key";
    private static final String TAG_LISTENSFOR = "listensfor";
    private static final String TAG_MANAGER = "manager";
    private static final String TAG_MAP = "map";
    private static final String TAG_LIST = "list";
    private static final String TAG_PERSISTENCE = "persistence";
    private static final String TAG_REMOTE_SYSTEM_PROVIDERS = "remote-system-providers";
    private static final String TAG_PROBLEM_ANALYSIS = "problem-analysis";
    private static final String TAG_PROBLEM_MANAGER = "problem-manager";
    private static final String TAG_ROUTINE = "routine";
    private static final String ATTRIB_NAME = "name";
    private static final String ATTRIB_LAZY = "lazy";
    private static final String ATTRIB_SUBCLASS = "subclass";

    public ProblemAnalysisXMLParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        Trace.trace(TRACE_MASKD, "ProblemAnalysisXMLParser.ctor");
    }

    public static ProblemAnalysisData parseXML(String fileName) throws MalformedXMLException {
        return ProblemAnalysisXMLParser.parseXML(new File(fileName));
    }

    public static ProblemAnalysisData parseXML(File file) throws MalformedXMLException {
        Trace.trace(TRACE_MASKT, "ProblemAnalysisXMLParser.parseXML(" + file + ")");
        try {
            ProblemAnalysisXMLParser parser = new ProblemAnalysisXMLParser();
            parser.parse(new InputSource(new FileInputStream(file)));
            Document doc = parser.getDocument();
            NodeList paChildren = doc.getElementsByTagName(TAG_PROBLEM_ANALYSIS);
            ProblemAnalysisData paConfigData = null;
            if (paChildren.getLength() != 1) {
                throw new MalformedXMLException("A single <problem-analysis> is expected.");
            }
            paConfigData = ProblemAnalysisXMLParser.parseProblemAnalysis(paChildren.item(0));
            return paConfigData;
        }
        catch (IOException e) {
            throw new MalformedXMLException("IOException reading file");
        }
        catch (ClassNotFoundException e) {
            throw new MalformedXMLException("ClassNotFoundException!");
        }
        catch (SAXException e) {
            throw new MalformedXMLException("SaxException! " + e);
        }
    }

    private static ProblemAnalysisData parseProblemAnalysis(Node node) throws ClassNotFoundException, MalformedXMLException {
        Trace.trace(TRACE_MASKD, "parsingProblemAnalysis ");
        ProblemAnalysisData paData = new ProblemAnalysisData();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Trace.trace(TRACE_MASKD, " Element_node = " + child.getNodeName() + " value= " + child.getNodeValue() + " type = " + child.getNodeType());
            if (TAG_PERSISTENCE.equals(child.getNodeName().toLowerCase())) {
                paData.setPersistenceData(ProblemAnalysisXMLParser.parsePersistence(child));
                continue;
            }
            if (TAG_REMOTE_SYSTEM_PROVIDERS.equals(child.getNodeName().toLowerCase())) {
                paData.setRemoteSystemProvidersData(ProblemAnalysisXMLParser.parseRemoteSystemProviders(child));
                continue;
            }
            if ("remote-system-manager".equals(child.getNodeName().toLowerCase())) {
                paData.setRemoteSystemManagerData(ProblemAnalysisXMLParser.parseRemoteSystemManager(child));
                continue;
            }
            if (TAG_EVENT_MANAGER.equals(child.getNodeName().toLowerCase())) {
                paData.addEventManagerData(ProblemAnalysisXMLParser.parseEventManager(child));
                continue;
            }
            if (TAG_EVENT_GENERATORS.equals(child.getNodeName().toLowerCase())) {
                paData.setEventGeneratorsData(ProblemAnalysisXMLParser.parseEventGenerators(child));
                continue;
            }
            if (TAG_SPECIAL_REFCODES.equals(child.getNodeName().toLowerCase())) {
                paData.setSpecialRefcodes(ProblemAnalysisXMLParser.parseSpecialRefcodes(child));
                continue;
            }
            throw new MalformedXMLException("parseProblemAnalysis: Unknown tag ??? " + child.getNodeName().toLowerCase());
        }
        return paData;
    }

    private static PersistenceData parsePersistence(Node node) throws ClassNotFoundException, MalformedXMLException {
        PersistenceData pData = new PersistenceData();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (TAG_PROBLEM_MANAGER.equals(child.getNodeName().toLowerCase())) {
                pData.setProblemManagerData(ProblemAnalysisXMLParser.parseProblemManager(child));
                continue;
            }
            throw new MalformedXMLException("parsePersistence: Unknown tag ??? " + child.getNodeName().toLowerCase());
        }
        return pData;
    }

    private static ProblemManagerData parseProblemManager(Node node) throws ClassNotFoundException, MalformedXMLException {
        ProblemManagerData pmData = new ProblemManagerData();
        Node name = node.getAttributes().getNamedItem(ATTRIB_SUBCLASS);
        if (name == null || name.getNodeType() != 2) {
            throw new MalformedXMLException("Unable to locate subclass attribute on <problem-manager> entry");
        }
        pmData.setSubclassName(name.getNodeValue());
        NodeList children = node.getChildNodes();
        ClassData classData = new ClassData();
        Map configData = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (TAG_CLASS.equals(child.getNodeName().toLowerCase())) {
                classData.setClassName(ProblemAnalysisXMLParser.gatherTextContents(child));
                continue;
            }
            if (TAG_CONFIG_DATA.equals(child.getNodeName().toLowerCase())) {
                configData = ConfigData.parseConfigData(child);
                continue;
            }
            throw new MalformedXMLException("parseProblemManager: Unknown tag ??? " + child.getNodeName().toLowerCase());
        }
        classData.setConfigData(configData);
        pmData.setClassData(classData);
        return pmData;
    }

    private static ConfigurationData parseConfiguration(Node node) throws ClassNotFoundException, MalformedXMLException {
        ConfigurationData cData = new ConfigurationData();
        cData.setConfigurationData(ConfigData.parseConfigData(node));
        return cData;
    }

    private static RemoteSystemProvidersData parseRemoteSystemProviders(Node node) throws ClassNotFoundException, MalformedXMLException {
        RemoteSystemProvidersData rspsData = new RemoteSystemProvidersData();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getNodeName().toLowerCase();
            if (childName.equals("remote-system-provider")) {
                RemoteSystemProviderData rspData = new RemoteSystemProviderData();
                rspData.parseXML(child);
                rspsData.addRemoteSystemProviderData(rspData.getName(), rspData);
                continue;
            }
            throw new MalformedXMLException("parseRemoteSystemProviders: Unknown element <" + childName + "> found in <" + node.getNodeName().toLowerCase() + ">");
        }
        return rspsData;
    }

    private static RemoteSystemManagerData parseRemoteSystemManager(Node node) throws ClassNotFoundException, MalformedXMLException {
        RemoteSystemManagerData rsmData = new RemoteSystemManagerData();
        rsmData.parseXML(node);
        return rsmData;
    }

    private static EventManagerData parseEventManager(Node node) throws ClassNotFoundException, MalformedXMLException {
        EventManagerData emData = new EventManagerData();
        emData.setName(CommonXMLParser.getRequiredAttribute(node, ATTRIB_NAME).getNodeValue());
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getNodeName().toLowerCase();
            if (childName.equals(TAG_CONFIG_DATA)) {
                emData.setConfigData(ProblemAnalysisXMLParser.parseConfiguration(child));
                continue;
            }
            if (childName.equals(TAG_ANALYSIS_DOMAINS)) {
                emData.setAnalysisDomainMap(ProblemAnalysisXMLParser.parseAnalysisDomains(child, emData));
                continue;
            }
            if (childName.equals(TAG_ANALYSIS_EVENTS)) {
                emData.setEventsData(ProblemAnalysisXMLParser.parseAnalysisEvents(child));
                continue;
            }
            if (childName.equals(TAG_ANALYSIS_ROUTINES)) {
                emData.setAnalysisRoutinesData(ProblemAnalysisXMLParser.parseAnalysisRoutines(child));
                continue;
            }
            throw new MalformedXMLException("parseEventManager: Unknown element <" + childName + "> found in <" + node.getNodeName().toLowerCase() + ">");
        }
        return emData;
    }

    private static ArrayList parseSpecialRefcodes(Node node) throws ClassNotFoundException, MalformedXMLException {
        ArrayList<String> refcodes = new ArrayList<String>();
        Trace.trace(TRACE_MASKD, "parsingSpecial refcodes this node name=" + node.getNodeName() + " value= " + node.getNodeValue() + " type = " + node.getNodeType());
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String childName;
            Node child = children.item(i);
            Trace.trace(TRACE_MASKD, "child " + node.getNodeName() + " value= " + node.getNodeValue() + " type = " + node.getNodeType());
            if (child.getNodeType() != 1 || !(childName = child.getNodeName().toLowerCase()).equals(TAG_REFCODE)) continue;
            Trace.trace(TRACE_MASKD, " this is a refcode" + node.getNodeName() + " value= " + node.getNodeValue() + " type = " + node.getNodeType());
            String thisRefcode = ProblemAnalysisXMLParser.gatherTextContents(child);
            if (thisRefcode == null && thisRefcode.trim().length() == 0) continue;
            refcodes.add(thisRefcode);
        }
        Trace.trace(TRACE_MASKD, "special refcode size =" + refcodes.size() + " toString" + refcodes.toString());
        return refcodes;
    }

    private static Map parseAnalysisDomains(Node node, EventManagerData emData) throws ClassNotFoundException, MalformedXMLException {
        HashMap<String, AnalysisDomainData> adMap = new HashMap<String, AnalysisDomainData>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getNodeName().toLowerCase();
            AnalysisDomainData add = null;
            if (childName.equals("console-analysis-domain")) {
                add = new ConsoleADData();
                add.parseXML(child);
            } else if (childName.equals("distributed-analysis-domain")) {
                add = new DistributedADData();
                ((DistributedADData)add).parseXML(child);
            } else {
                throw new MalformedXMLException("parseAnalysisDomains: Unknown element <" + childName + "> found in <" + node.getNodeName().toLowerCase() + ">");
            }
            adMap.put(add.getName(), add);
        }
        return adMap;
    }

    private static AnalysisEventsData parseAnalysisEvents(Node node) throws ClassNotFoundException, MalformedXMLException {
        AnalysisEventsData aeData = new AnalysisEventsData();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (TAG_EVENT.equals(child.getNodeName().toLowerCase())) {
                AnalysisEventData aData = ProblemAnalysisXMLParser.parseAnalysisEvent(child);
                aeData.addAnalysisEventData(aData.getName(), aData);
                continue;
            }
            throw new MalformedXMLException("parseAnalysisEvents: Unknown tag ??? " + child.getNodeName().toLowerCase());
        }
        return aeData;
    }

    private static AnalysisEventData parseAnalysisEvent(Node node) throws ClassNotFoundException, MalformedXMLException {
        AnalysisEventData aeData = new AnalysisEventData();
        if (node.getNodeType() == 1) {
            Node name = node.getAttributes().getNamedItem(ATTRIB_NAME);
            if (name == null || name.getNodeType() != 2) {
                throw new MalformedXMLException("Unable to locate name attribute on <event> entry");
            }
            aeData.setName(name.getNodeValue());
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                if (TAG_CLASS.equals(child.getNodeName().toLowerCase())) {
                    aeData.setClassName(ProblemAnalysisXMLParser.gatherTextContents(child));
                    continue;
                }
                throw new MalformedXMLException("parseAnalysisEvent: Unknown tag ??? " + child.getNodeName().toLowerCase());
            }
        }
        return aeData;
    }

    private static AnalysisRoutinesData parseAnalysisRoutines(Node node) throws ClassNotFoundException, MalformedXMLException {
        AnalysisRoutinesData arData = new AnalysisRoutinesData();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (TAG_ROUTINE.equals(child.getNodeName().toLowerCase())) {
                AnalysisRoutineData rData = ProblemAnalysisXMLParser.parseAnalysisRoutine(child);
                arData.addAnalysisRoutineData(rData.getName(), rData);
                continue;
            }
            throw new MalformedXMLException("parseAnalysisRoutines: Unknown tag ??? " + child.getNodeName().toLowerCase());
        }
        return arData;
    }

    private static AnalysisRoutineData parseAnalysisRoutine(Node node) throws ClassNotFoundException, MalformedXMLException {
        AnalysisRoutineData arData = new AnalysisRoutineData();
        if (node.getNodeType() == 1) {
            Node name = node.getAttributes().getNamedItem(ATTRIB_NAME);
            arData.setName(name.getNodeValue());
            Node lazy = node.getAttributes().getNamedItem(ATTRIB_LAZY);
            if (lazy != null) {
                if ("true".equals(lazy.getNodeValue().toLowerCase())) {
                    arData.setLazy(true);
                } else {
                    arData.setLazy(false);
                }
            } else {
                arData.setLazy(false);
            }
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                if (TAG_CLASS.equals(child.getNodeName().toLowerCase())) {
                    arData.setClassName(ProblemAnalysisXMLParser.gatherTextContents(child));
                    continue;
                }
                if (TAG_LISTENSFOR.equals(child.getNodeName().toLowerCase())) {
                    arData.addEventName(ProblemAnalysisXMLParser.gatherTextContents(child));
                    continue;
                }
                throw new MalformedXMLException("parseAnalysisRoutine: Unknown tag ??? " + child.getNodeName().toLowerCase());
            }
        }
        return arData;
    }

    private static EventGeneratorsData parseEventGenerators(Node node) throws ClassNotFoundException, MalformedXMLException {
        EventGeneratorsData egsData = new EventGeneratorsData();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().toLowerCase().equals("generator")) {
                EventGeneratorData egData = new EventGeneratorData();
                egData.parseXML(child);
                egsData.addEventGeneratorData(egData.getName(), egData);
                continue;
            }
            throw new MalformedXMLException("parseEventGenerators: Unknown tag ??? " + child.getNodeName().toLowerCase());
        }
        return egsData;
    }
}

